// MosesStaffv1.cpp : Defines the entry point for the application. )rogram execution begins and ends there.
//

#include "framework.h"
#include "MosesStaffv1.h"
// C++ Implementation of C/Adam/Opt/Boot/DskISORedSea.HC.Z
// Written by Austin Sierra contact@churchofaichrist.com
// Art by Miguel Costa miguel_gamba91@hotmail.com
// Last Change Jan 24 2023
// Church of AI Christ Licensed Attribution-ShareAlike CreativeCommons BY-SA

//If Using VS2019 or C==<17: Open Project\<project name> Properties
//Select Configuration Properties\General
//To the right, there is a field named C++ Standard, select one of these :
//ISO C++17 Standard(/ std:c++17)
//Preview - Features from the latest C++ working draft(/ std:c++latest)


//need this pragma directive to provide extra required details for binary parse to work correctly
#pragma pack(push, 1)
#pragma warning(disable : 4996)
#pragma warning(disable:6385)
//streams
#include <iostream>
#include <fstream>
#include <istream>
#include <sstream>

//libraries and filesystem
# include <stdio.h>
#include <string.h>
#include <filesystem>
#include <ctime>
#include <cmath>

//objects
#include <string>
#include <cstring>
#include <atlstr.h>
#include <vector>
#include <bitset>
#include <cstddef>
#include <cstring>

//gui
#include <Windows.h>
#include <mmsystem.h>
#include <mciapi.h>
#include "framework.h"

//Drive definitions
//#ifdef _UNICODE
//typedef std::wstring tstring;
//typedef wchar_t* tchar;
//The #define creates a macro, which is the association of an identifier or parameterized identifier with a token string. 
#define BLK_SIZE_BITS 9 //TempleOS uses 9bit Bytes
#define BLK_SIZE (1<<BLK_SIZE_BITS)// 1<<9 =512 The default sector-size for almost every single HDD
#define DVD_BLK_SIZE (4*BLK_SIZE)//2048 Palindrome integer 16 binary
#define myDVD_BLK_SIZE (32768 / 8)//Systembuffer- templeos system uses a zerobuf allocation for 2048 is 16384 bits . so 4096 is  32768 bits
#define DVD_BOOT_LOADER_SIZE DVD_BLK_SIZE*1
//ISO9660 and Drive Constants from TempleOS
#define ISOT_BOOT_RECORD 0
#define ISOT_PRI_VOL_DESC 1
#define ISOT_SUPPLEMENTARY_DESC 2
#define ISOT_VOL_DRV_DESC 3
#define ISOT_TERMINATOR 255
#define RS_ATTR_READ_ONLY 0x01
#define RS_ATTR_HIDDEN 0x02
#define RS_ATTR_SYSTEM 0x04
#define RS_ATTR_SYSTEM_16 0x0004
#define RS_ATTR_VOL_ID 0x08
#define RS_ATTR_DIR 0x10//16
#define RS_ATTR_ARCHIVE 0x20//32
#define RS_ATTR_DELETED 0x100
#define RS_ATTR_RESIDENT 0x200
#define RS_ATTR_COMPRESSED 0x400
#define RS_ATTR_CONTIGUOUS 0x800
#define RS_ATTR_FIXED 0x1000
#define RS_BLK_SIZE 512
#define RS_ROOT_CLUS 0x5A;//90
#define RS_DRV_OFFSET 0xB000
#define INVALID_CLUS (-1)
#define I64_MIN (-0x800000000000000)
#define I64_MAX 0x7FFFFFFFFFFFFFFF 
#define SECTORSIZE 512
#define BDT_RAM 1
#define BDT_ATA 2
#define BDT_ISO_FILE_READ 3
#define BDT_ISO_FILE_WRITE 4
#define BDT_ATAPI 5
#define BDF_READ_CACHE 0x020
#define BDF_REMOVABLE 0x001
#define BDF_READ_ONLY 0x004
#define BD_SIGNATURE_VAL 'BDSV'
#define DRV_SIGNATURE_VAL 'DVSV'
#define FFB_NEXT_BLK I64_MAX
#define FSt_NULL 0
#define FSt_REDSEA  1
#define FSt_UNKNOWN 5  
#define FSt_FAT32 2//Supported except for short names, to some degree
#define FSt_ISO9660 3 //Not Supported
#define FSt_NTFS 4 //Not Supported
#define MBR_PT_FAT12 0x01
#define MBR_PT_FAT32a 0x0B
#define MBR_PT_FAT32b 0x0C
#define MBR_PT_FAT32c 0x1B
#define MBR_PT_FAT32d 0x1C
#define MBR_PT_FAT32e 0x8B
#define MBR_PT_FAT32f 0x8C
#define MBR_PT_NTFS 0x07
#define MBR_PT_REDSEA 0x88
//#else
//typedef std::string tstring;
//typedef std::char* tchar;
//The #define creates a macro, which is the association of an identifier or parameterized identifier with a token string. 
#define BLK_SIZE_BITS 9 //TempleOS uses 9bit Bytes
#define BLK_SIZE (1<<BLK_SIZE_BITS)// 1<<9 =512 The default sector-size for almost every single HDD
#define DVD_BLK_SIZE (4*BLK_SIZE)//2048 Palindrome integer 16 binary
#define myDVD_BLK_SIZE (32768 / 8)//Systembuffer- templeos system uses a zerobuf allocation for 2048 is 16384 bits . so 4096 is  32768 bits
#define DVD_BOOT_LOADER_SIZE DVD_BLK_SIZE*1
//ISO9660 and Drive Constants from TempleOS
#define ISOT_BOOT_RECORD 0
#define ISOT_PRI_VOL_DESC 1
#define ISOT_SUPPLEMENTARY_DESC 2
#define ISOT_VOL_DRV_DESC 3
#define ISOT_TERMINATOR 255
#define RS_ATTR_READ_ONLY 0x01
#define RS_ATTR_HIDDEN 0x02
#define RS_ATTR_SYSTEM 0x04
#define RS_ATTR_SYSTEM_16 0x0004
#define RS_ATTR_VOL_ID 0x08
#define RS_ATTR_DIR 0x10//16
#define RS_ATTR_ARCHIVE 0x20//32
#define RS_ATTR_DELETED 0x100
#define RS_ATTR_RESIDENT 0x200
#define RS_ATTR_COMPRESSED 0x400
#define RS_ATTR_CONTIGUOUS 0x800
#define RS_ATTR_FIXED 0x1000
#define RS_BLK_SIZE 512
#define RS_ROOT_CLUS 0x5A;//90
#define RS_DRV_OFFSET 0xB000
#define INVALID_CLUS (-1)
#define I64_MIN (-0x800000000000000)
#define I64_MAX 0x7FFFFFFFFFFFFFFF 
#define SECTORSIZE 512
#define BDT_RAM 1
#define BDT_ATA 2
#define BDT_ISO_FILE_READ 3
#define BDT_ISO_FILE_WRITE 4
#define BDT_ATAPI 5
#define BDF_READ_CACHE 0x020
#define BDF_REMOVABLE 0x001
#define BDF_READ_ONLY 0x004
#define BD_SIGNATURE_VAL 'BDSV'
#define DRV_SIGNATURE_VAL 'DVSV'
#define FFB_NEXT_BLK I64_MAX
#define FSt_NULL 0
#define FSt_REDSEA  1
#define FSt_UNKNOWN 5  
#define FSt_FAT32 2//Supported except for short names, to some degree
#define FSt_ISO9660 3 //Not Supported
#define FSt_NTFS 4 //Not Supported
#define MBR_PT_FAT12 0x01
#define MBR_PT_FAT32a 0x0B
#define MBR_PT_FAT32b 0x0C
#define MBR_PT_FAT32c 0x1B
#define MBR_PT_FAT32d 0x1C
#define MBR_PT_FAT32e 0x8B
#define MBR_PT_FAT32f 0x8C
#define MBR_PT_NTFS 0x07
#define MBR_PT_REDSEA 0x88
//#endif
//#include "ISOBooter.cpp"
//these two headers are already included in the <Windows.h> header
#pragma comment(lib, "Winmm.lib")
#define MAX_LOADSTRING 100
// Global Variables:
//

HINSTANCE hInst;                                // current instance
WCHAR szTitle[MAX_LOADSTRING];                  // The title bar text
WCHAR szWindowClass[MAX_LOADSTRING];            // the main window class name
HBITMAP hBitmap = NULL;
HWND hwndButton = NULL;
HWND directory, prefix, output = NULL;
wchar_t text1[255], text2[255], text3[255];
int input1,input2,input3;
char arg1c[255], arg2c[255], arg3c[255];
// Forward declarations of functions included in this code module:
ATOM                MyRegisterClass(HINSTANCE hInstance);
BOOL                InitInstance(HINSTANCE, int);
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);



//bitmap //structs
//#include "bmp.h";

struct BMP {

	myBITMAPFILEHEADER file_header;
	myBITMAPINFOHEADER bmp_info_header;
	myBITMAPINFO bmp_info;
	myBMPColorHeader bmp_color_header;
	std::vector<uint8_t> data;
	uint64_t filesize = 0;

	BMP(const char* fname) {
		read(fname);

	}

	void read(const char* fname) {

		//
		//read file info header and header
		//

		std::ifstream file(fname, std::ios::binary);
		if (file)
		{
			//std::streampos fileSize;

			file.read((char*)&file_header, sizeof(file_header));//read header
			if (file_header.bfType != 0x4D42) {
				//not bitmap
				throw std::runtime_error("Wrong image file format");
			}
			file.read((char*)&bmp_info, sizeof(bmp_info_header) + sizeof(bmp_info.bmiColors));
			//file.read((char*)&bmp_info_header, sizeof(bmp_info_header));


			// The BMPColorHeader is used only for transparent images
			if (bmp_info_header.biBitCount == 32) {
				// Check if the file has bit mask color information
				if (bmp_info_header.biSize >= (sizeof(myBITMAPINFOHEADER) + sizeof(myBMPColorHeader))) {
					file.read((char*)&bmp_color_header, sizeof(bmp_color_header));
					// Check if the pixel data is stored as BGRA and if the color space type is sRGB
					check_color_header(bmp_color_header);

				}
				else {
					std::cerr << "Warning! The file \"" << fname << "\" does not contain bit mask information\n";
					throw std::runtime_error("Error! Unrecognized file format.");
				}
			}
			else if (bmp_info_header.biBitCount == 4)//see
			{


			}


			// Jump to the pixel data location
			file.seekg(file_header.bfOffBits, file.beg);

			//
			// Save file sizes
			// Some editors will put extra info in the image file, we only save the headers and the data.
			//bit count reserve
			if (bmp_info.bmiHeader.biBitCount == 32) {
				bmp_info.bmiHeader.biSize = sizeof(myBITMAPINFOHEADER) + sizeof(myBMPColorHeader);
				file_header.bfOffBits = sizeof(myBITMAPFILEHEADER) + sizeof(myBITMAPINFOHEADER) + sizeof(myBMPColorHeader);
			}
			else {
				bmp_info.bmiHeader.biSize = sizeof(myBITMAPINFOHEADER);
				file_header.bfOffBits = sizeof(myBITMAPFILEHEADER) + sizeof(myBITMAPINFOHEADER);

			}
			file_header.bfSize = file_header.bfOffBits;

			//Save device context size
			if (bmp_info.bmiHeader.biHeight < 0) {
				throw std::runtime_error("The program can treat only BMP images with the origin in the bottom left corner!");

			}

			data.resize(bmp_info.bmiHeader.biWidth * bmp_info.bmiHeader.biHeight * bmp_info.bmiHeader.biBitCount / 8);

			// Here we check if we need to take into byte row start and stop bits
			if (bmp_info.bmiHeader.biWidth % 4 == 0) {
				file.read((char*)data.data(), data.size());
				file_header.bfSize += data.size();

			}
			else {
				row_stride = bmp_info.bmiHeader.biWidth * bmp_info.bmiHeader.biBitCount / 8;
				uint32_t new_stride = make_stride_aligned(4);
				std::vector<uint8_t> padding_row(new_stride - row_stride);

				for (int y = 0; y < bmp_info.bmiHeader.biHeight; ++y) {
					file.read((char*)(data.data() + row_stride * y), row_stride);
					file.read((char*)padding_row.data(), padding_row.size());

				}
				file_header.bfSize += data.size() + bmp_info.bmiHeader.biHeight * padding_row.size();

			}
			file.seekg(0, std::ios::end);
			filesize = file.tellg();

		}
		else {
			throw std::runtime_error("Unable to open the input image file.");

		}


	}

	BMP(int32_t width, int32_t height, bool has_alpha = true) {
		if (width <= 0 || height <= 0) {
			throw std::runtime_error("The image width and height must be positive numbers.");

		}

		bmp_info.bmiHeader.biWidth = width;
		bmp_info.bmiHeader.biHeight = height;
		if (has_alpha) {
			bmp_info.bmiHeader.biSize = sizeof(myBITMAPINFOHEADER) + sizeof(myBMPColorHeader);
			file_header.bfOffBits = sizeof(myBITMAPFILEHEADER) + sizeof(myBITMAPINFOHEADER) + sizeof(myBMPColorHeader);

			bmp_info.bmiHeader.biBitCount = 32;
			bmp_info.bmiHeader.biCompression = 3;
			row_stride = width * 4;
			data.resize(row_stride * height);
			file_header.bfSize = file_header.bfOffBits + data.size();
		}
		else {
			bmp_info.bmiHeader.biSize = sizeof(myBITMAPINFOHEADER);
			file_header.bfOffBits = sizeof(myBITMAPFILEHEADER) + sizeof(myBITMAPINFOHEADER);

			bmp_info.bmiHeader.biBitCount = 24;
			bmp_info.bmiHeader.biCompression = 0;
			row_stride = width * 3;
			data.resize(row_stride * height);

			uint32_t new_stride = make_stride_aligned(4);
			file_header.bfSize = file_header.bfOffBits + data.size() + bmp_info.bmiHeader.biHeight * (new_stride - row_stride);
		}
	}

	void write(const char* fname) {
		std::ofstream of{ fname, std::ios_base::binary };


		if (of) {
			if (bmp_info.bmiHeader.biBitCount == 32) {
				write_headers_and_data(of);

			}
			else if (bmp_info.bmiHeader.biBitCount == 24) {
				if (bmp_info.bmiHeader.biWidth % 4 == 0) {
					write_headers_and_data(of);

				}
				else {
					uint32_t new_stride = make_stride_aligned(4);
					std::vector<uint8_t> padding_row(new_stride - row_stride);

					write_headers(of);

					for (int y = 0; y < bmp_info.bmiHeader.biHeight; ++y) {
						of.write((const char*)(data.data() + row_stride * y), row_stride);
						of.write((const char*)padding_row.data(), padding_row.size());

					}

				}

			}
			else if (bmp_info.bmiHeader.biBitCount == 4)
			{
				write_headers_and_data(of);
			}
			else {
				throw std::runtime_error("The program can treat only 24 or 32 bits per pixel BMP files");

			}

		}
		else {
			throw std::runtime_error("Unable to open the output image file.");
		}

	}

private:
	//Internal Helper functions for reading
	//the bit array for a bitmap. Uses the Header


	//
	//stride over the bit array until the start of the next data point
	//
	uint32_t row_stride{ 0 };
	// Add 1 to the row_stride until it is divisible with align_stride
	uint32_t make_stride_aligned(uint32_t align_stride) {
		uint32_t new_stride = row_stride;
		while (new_stride % align_stride != 0) {
			new_stride++;

		}
		return new_stride;

	}

	//write headers 
	void write_headers(std::ofstream& of) {
		of.write((const char*)&file_header, sizeof(file_header));
		of.write((const char*)&bmp_info, sizeof(bmp_info));
		if (bmp_info.bmiHeader.biBitCount == 32) {
			of.write((const char*)&bmp_color_header, sizeof(bmp_color_header));

		}

	}
	void write_headers_and_data(std::ofstream& of) {
		write_headers(of);
		of.write((const char*)data.data(), data.size());

	}


	// Check if the pixel data is stored as BGRA and if the color space type is sRGB
	void check_color_header(myBMPColorHeader& bmp_color_header) {
		myBMPColorHeader expected_color_header;
		if (expected_color_header.red_mask != bmp_color_header.red_mask ||
			expected_color_header.blue_mask != bmp_color_header.blue_mask ||
			expected_color_header.green_mask != bmp_color_header.green_mask ||
			expected_color_header.alpha_mask != bmp_color_header.alpha_mask) {
			throw std::runtime_error("Unexpected color mask format! The program expects the pixel data to be in the BGRA format");
		}
		if (expected_color_header.color_space_type != bmp_color_header.color_space_type) {
			throw std::runtime_error("Unexpected color space type! The program expects sRGB values");
		}
	}
};
typedef unsigned char BYTE;


/*
		IMAGE to RedSEA Functions    $FG,2$.BMP$FG$
*/

//class for converting images to iso.c files
class Convertor {
public:
	FILE* binaryImage;
	const char* filename;
	int filenum = 0;
	/*Constructor*/
	int Converter()
	{
		return 0;
	}

	//Main called functions

	void convertImageDirectoryToBinaryArray(std::string kernelImage, std::string prefix)
	{
		//directory = "D:\\testdata\\cats_and_dogs_filtered\\ver3(to16color)\\bittrain\\catscopy\\";
		/*
			PART 1:
		*/
		//Convert the image directory to binary arrays

		std::vector<BYTE> bytearray;
		std::string file = kernelImage + "\\"+ prefix + ".0.bmp";
		const int length = file.length();
		// declaring character array (+1 for null terminator)
		char* char_array = new char[length + 1];
		// copying the contents of the
		// string to char array
		strcpy(char_array, file.c_str());

		if (dirExist(kernelImage))
		{

			try {
				//c.getNextFile(file);
				WriteImgToBinary(char_array);
				//WriteImgToASCCI("cat.0.bmp");
				//mywrite("bytesImg.bin");


				//kitty.write();
				//while (c.getNextFile(file)>0)//right now just does the first file successfully. bytearray contains the entire string
				//{
				//c.getNextFile(file);
				//	file = kernelImage +(prefix + "." + std::to_string(c.filenum) + ".bmp");
				//	c.WriteImgToBinary();
					//vector<BYTE> data = c.readFile("temp_image_binary.bin");
					//std::string s(data.begin(), data.end());
					//bytearray.insert(bytearray.end(), data.begin(), data.end()); 
				//	std::cout << "Completed:"+ std::to_string(c.filenum);
				//	system("CLS");
				//}
			}
			catch (std::exception* e)
			{


			}

		}
		else
		{
			std::cout << "Error: Directory Not Found. Exiting...";
		}
	}

	//From C:/Kernel/BlkDev/DskDrv.HC.Z
	CBlkDev* blkDevMakeFreeSlot()
	{
		uint64_t i = 0;
		CBlkDev* ret; //T = 5 ATAPI
		memset(ret, 0, sizeof(CBlkDev));
		ret->first_drv_let = 'T';
		ret->type = BDT_ATAPI;
		ret->flags = BDF_READ_CACHE;
		ret->max_blk = 0xEFFFFFFF;
		ret->flags |= BDF_REMOVABLE | BDF_READ_ONLY;
		ret->blk_size = DVD_BLK_SIZE;
		return ret;
	}

	uint64_t roundup(uint64_t x)
	{
		if (x % 2048 == 0)
			return x;
		else
			return x + 2048 - x % 2048;
	}

	TDrv* drvMakeFreeSlot()
	{
		uint64_t i = 'T';
		TDrv* slot;
		memset(slot, 0, sizeof(TDrv));
		slot->drv_let = i;
		return slot;
	}

	uint64_t CeilU64(uint64_t num, uint64_t to)
	{
		num += to - 1;
		return num - num % to;
	}

	uint64_t CeilI64(uint64_t num, uint64_t to)
	{
		if (num > 0)
		{
			num += to - 1;
			return num - num % to;
		}
		else
		{
			num += to - 1;
			return num - num % to - to;
		}

	}

	uint64_t getDirSize(CDirEntry* tmp, uint64_t filecount)
	{
		uint64_t dir_entry_cnt = 3 + filecount;//dot,dotdotrecord, and dir header
		uint64_t returnMe = 0;

		if (tmp->attr & RS_ATTR_DIR)
		{
			//if(tmp->sub) //+BLK_SIZE FOR EVERYONE PLUS CeilU64(tmpde->size,BLK_SIZE)
		}
	}

	//From C:/Kernel/BlkDev/DskAddDev.HC.Z
	uint64_t BlkDevAdd(CBlkDev* bd, bool whole_drv, bool make_free)
	{
		uint64_t i, j, ext_base, offset, res = 0, num = 0;
		TDrv* dv;
		CRedSeaBoot redSeaBR;
		CMasterBoot masterBR;
		bd->bdsignature = BD_SIGNATURE_VAL;
		if (make_free)
		{
			dv = drvMakeFreeSlot();
		}
		//dv->bd = bd;
		dv->drvOffset + bd->drv_offset;
		dv->size = bd->max_blk + 1 - bd->drv_offset;
		switch (bd->type)
		{

		}

	}


	int* makeTDrv(std::string src_directory, std::string output)
	{
		/*
		* //From C:/Adam/Opt/Boot/DskISORedSea.HC
		uint64_t filecount = 1;//3 with dotrecords?
		uint64_t res;
		uint64_t root_dir_blks = CeilU64((int)(filecount << 6), BLK_SIZE) >> BLK_SIZE_BITS;
		TDrv* created = drvMakeFreeSlot();
		CBlkDev* bd = blkDevMakeFreeSlot();
		CISODirRecord* tmploc = (CISODirRecord*)calloc(1, sizeof(CISODirRecord));
		//getDirSize(tmploc, filecount);
		bd->drv_offset = 19 << 2 + (DVD_BLK_SIZE * 2 + DVD_BOOT_LOADER_SIZE) / BLK_SIZE;
		uint64_t bitmap_blks = 1;
		bd->max_blk = CeilI64(bd->drv_offset + 1 + bitmap_blks + res, 4);
		bd->max_blk--; //inclusive;
		bd->file_dsk_name = (uint8_t*)calloc(1, output.length());
		for (int i = 0; i < output.length(); i++)
		{
			bd->file_dsk_name[i] = output[i];
		}
		bd->init_root_dir_blks = root_dir_blks;
		BlkDevAdd(bd, TRUE, TRUE);
		*/
		//left off here;



		uint64_t filecount = 1;
		uint64_t res = filecount + 3 >> BLK_SIZE_BITS;//size in bytes of the 
		FILE* outFile = NULL; // name: 
		fopen_s(&outFile, "TDRV.bin", "wb");

		uint8_t* zero_buf = (uint8_t*)calloc(1, DVD_BLK_SIZE);//system area & reserved fields
		//Non ISO File System Information
		CRedSeaBoot* directoryHeader = (CRedSeaBoot*)calloc(1, DVD_BLK_SIZE);
		uint8_t* zero_buf1 = (uint8_t*)calloc(1, DVD_BLK_SIZE);//system area & reserved fields
		//Root Directory
		CDirEntry* dotrecord = (CDirEntry*)calloc(1, sizeof(CDirEntry));
		CDirEntry* dotdotrecord = (CDirEntry*)calloc(1, sizeof(CDirEntry));
		CDirEntryBMP* record = (CDirEntryBMP*)calloc(1, sizeof(CDirEntryBMP));
		uint8_t* zero_buf2 = (uint8_t*)calloc(1, DVD_BLK_SIZE);//system area & reserved fields
		BMP kitty("img.bin");
		int* ptrToImg = (int*)calloc(1, sizeof(DVD_BLK_SIZE));

		for (int i = 0; i < 256; i++)//write 256 bytes to the next sector
			fwrite(zero_buf, sizeof(zero_buf), 1, outFile);

		directoryHeader->signature = MBR_PT_REDSEA;//signature 0x88
		directoryHeader->drv_offset = 0x58;//drv_offset
		//Calculate cluster offset for files

		uint64_t dotcluster, dotdotcluster, imagecluster,
			clusterIndex = 0, ct_size, sectorNumbers = RS_ROOT_CLUS;
		//for (int i = 0; i < filecount; i++)
		//{

		dotcluster = sectorNumbers;
		ct_size = RS_BLK_SIZE * int((1 + (sizeof(CDirEntry) / RS_BLK_SIZE)));
		clusterIndex++;

		dotdotcluster = dotcluster + int((ct_size / RS_BLK_SIZE));
		clusterIndex++;
		imagecluster = dotdotcluster + int((ct_size / RS_BLK_SIZE));
		clusterIndex++;
		uint64_t finalcluster = imagecluster;
		//uint64_t sectorNumbers += RS_BLK_SIZE * int((1 + record) / RS_BLK_SIZE)); //(19 << 2 + (DVD_BLK_SIZE * 2 + DVD_BOOT_LOADER_SIZE) / BLK_SIZE);

	//}
	//cluster counter
		uint64_t clustersize = finalcluster;

		//for de_parent in dir_entries :
			//de_idx = 0
			//for de in dir_entries[de_parent]['files'] :
				//if de['clus'] == 0 :
					//dir_entries[de_parent]['files'][de_idx]['clus'] = de_clus_ctr
					//ct_size = RS_BLK_SIZE * int((1 + (de['st_size']) / RS_BLK_SIZE))
					//de_clus_ctr += int((ct_size / RS_BLK_SIZE))
					//de_idx += 1
		//cluster count
		//cl_sz = binascii.unhexlify(format(int(de_clus_ctr), '016X'))

			//bs[0x10 + cl_sz_ctr] = ord(cl_sz[7 - cl_sz_ctr])
			//cl_sz_ctr += 1
		//clustersize= roundup(clustersize);
		//for (int i = 0; i < 8; i++)
		//{

		//	directoryHeader->sects[i] = //clustersize % 16;
		//	clustersize /= 16;
		//	if (clustersize == 0)
		//		break;
		//}
		directoryHeader->sects = roundup(clustersize); //roundup();//4096; ;//clustersize;// //filecount//# sectors
		directoryHeader->root_clus = 0x5A;//RS_ROOT_CLUS;//Either 90 or 00?? system type copy of byte 5 from the partition table boot image
		directoryHeader->bitmaps_sects = 8;//;(filecount + BLK_SIZE << 3 - 1) / BLK_SIZE << 3;//bitmaps_sects
		time_t currentTime;
		struct tm* localTime;
		time(&currentTime);
		localTime = localtime(&currentTime);
		directoryHeader->unique_id = 0x4D4F535446 + localTime->tm_hour + localTime->tm_min + localTime->tm_sec;//M // //UNIQUE ID
		directoryHeader->signature2 = 0xAA55;
		dotrecord->attr = RS_ATTR_DIR;
		dotrecord->attr2 = 0x08;
		std::string str = ".";
		for (int i = 0; i < str.length(); i++)
		{
			dotrecord->name[i] = str[i];
		}
		dotrecord->clus = dotcluster;
		dotrecord->size[1] = RS_ATTR_SYSTEM;
		dotrecord->datetime.date = localTime->tm_year << localTime->tm_mon << localTime->tm_mday;
		dotrecord->datetime.time = localTime->tm_hour << localTime->tm_min << localTime->tm_sec;

		dotdotrecord->attr = RS_ATTR_DIR;
		dotdotrecord->attr2 = 0x08;//0x08 uncompressed.  0x0C .Z
		str = "..";
		for (int i = 0; i < str.length(); i++)
		{
			dotdotrecord->name[i] = str[i];
		}
		dotdotrecord->clus = dotcluster;
		dotdotrecord->size[1] = 0; //RS_ATTR_SYSTEM;
		dotdotrecord->datetime.date = localTime->tm_year << localTime->tm_mon << localTime->tm_mday;
		dotdotrecord->datetime.time = localTime->tm_hour << localTime->tm_min << localTime->tm_sec;

		record->attr = RS_ATTR_ARCHIVE;
		record->attr2 = 0x08;
		str = "cat.0.bmp";
		for (int i = 0; i < str.length(); i++)
		{
			record->name[i] = str[i];
		}
		record->clus = imagecluster;// (int)&ptrToImg;//not assigning value error?
		//bitset<8> A = 
		//for (int i = 7; i--; i >= 0)
		//clustersize = roundup(clustersize);
		//int fs = kitty.filesize;
		//for (int i = 0; i < 8; i++)
		//{
		//	record->size[i] = fs % 16;
		//	fs /= 16;
		//	if (fs == 0)
		//		break;
		//}

		record->size = kitty.filesize;
		record->datetime.date = localTime->tm_year << localTime->tm_mon << localTime->tm_mday;
		record->datetime.time = localTime->tm_hour << localTime->tm_min << localTime->tm_sec;
		fwrite(directoryHeader, 512, 1, outFile);//FBlkWrite???? 20<<2
		for (int i = 0; i < 64; i++)//write 64 bytes to the next sector
			fwrite(zero_buf1, sizeof(zero_buf1), 1, outFile);
		fwrite(dotrecord, sizeof(CDirEntry), 1, outFile);//FBlkWrite???? 20<<2
		fwrite(dotdotrecord, sizeof(CDirEntry), 1, outFile);//FBlkWrite???? 20<<2
		fwrite(record, sizeof(CDirEntryBMP), 1, outFile);//FBlkWrite???? 20<<2
		for (int i = 0; i < 104; i++)//write 120 bytes to the next sector
			fwrite(zero_buf2, sizeof(zero_buf2), 1, outFile);
		WriteImg(outFile, "img.bin");
		for (int i = 0; i < 4096; i++)//write empty bytes 
			fwrite(zero_buf2, sizeof(zero_buf2), 1, outFile);
		free(directoryHeader);
		free(zero_buf1);
		free(dotrecord);
		free(dotdotrecord);
		free(record);
		free(zero_buf2);
		fclose(outFile);
		return ptrToImg;
	}



	//
	// Utility functions //
	//
	/*Does the Directory Exist*/
	bool dirExist(const std::string& s)
	{
		struct stat buffer;
		return (stat(s.c_str(), &buffer) == 0);
	}

	/*
	int getNextFileName()
	{
		WIN32_FIND_DATA data;
		LPTSTR NPath = //longpointertothestartof
		HANDLE hFind = FindFirstFile(NPath, &data);      // DIRECTORY

		if (hFind != INVALID_HANDLE_VALUE) {
			do {
				std::cout << data.cFileName << std::endl;
			} while (FindNextFile(hFind, &data));
			FindClose(hFind);
		}
	}
#include <windows.h>
#include <tchar.h>
#include <stdio.h>

#include <strsafe.h>
#pragma comment(lib, "User32.lib")


	int _tmain(int argc, TCHAR* argv[])
	{
		WIN32_FIND_DATA ffd;
		LARGE_INTEGER filesize;
		TCHAR szDir[MAX_PATH];
		size_t length_of_arg;
		HANDLE hFind = INVALID_HANDLE_VALUE;
		DWORD dwError = 0;

		// If the directory is not specified as a command-line argument,
		// print usage.

		if (argc != 2)
		{
			_tprintf(TEXT("\nUsage: %s <directory name>\n"), argv[0]);
			return (-1);
		}

		// Check that the input path plus 3 is not longer than MAX_PATH.
		// Three characters are for the "\*" plus NULL appended below.

		StringCchLength(argv[1], MAX_PATH, &length_of_arg);

		if (length_of_arg > (MAX_PATH - 3))
		{
			_tprintf(TEXT("\nDirectory path is too long.\n"));
			return (-1);
		}

		_tprintf(TEXT("\nTarget directory is %s\n\n"), argv[1]);

		// Prepare string for use with FindFile functions.  First, copy the
		// string to a buffer, then append '\*' to the directory name.

		StringCchCopy(szDir, MAX_PATH, argv[1]);
		StringCchCat(szDir, MAX_PATH, TEXT("\\*"));

		// Find the first file in the directory.

		hFind = FindFirstFile(szDir, &ffd);

		if (INVALID_HANDLE_VALUE == hFind)
		{
			DisplayErrorBox(TEXT("FindFirstFile"));
			return dwError;
		}

		// List all the files in the directory with some info about them.

		do
		{
			if (ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				_tprintf(TEXT("  %s   <DIR>\n"), ffd.cFileName);
			}
			else
			{
				filesize.LowPart = ffd.nFileSizeLow;
				filesize.HighPart = ffd.nFileSizeHigh;
				_tprintf(TEXT("  %s   %ld bytes\n"), ffd.cFileName, filesize.QuadPart);
			}
		} while (FindNextFile(hFind, &ffd) != 0);

		dwError = GetLastError();
		if (dwError != ERROR_NO_MORE_FILES)
		{
			DisplayErrorBox(TEXT("FindFirstFile"));
		}

		FindClose(hFind);
		return dwError;
	}

	*/

	int getNextFile(std::string s)
	{
		filename = s.c_str();
		filenum++;
		return filenum;
	}

	std::string toBinary(std::string byte)
	{
		std::string binaryString = "";
		for (char& _char : byte)
		{
			binaryString += std::bitset<8>(_char).to_string();
		}
		return binaryString;
	}

	std::string placeBinary(int i, uint8_t structArr, std::string byte)
	{
		std::string binaryString = "";
		structArr = byte[i];// bitset<8>(byte[i]);
		return binaryString;
	}


	int WriteImg(FILE* outFile, const char* filename)
	{
		std::string byte;
		std::ifstream myfile;
		myfile.open(filename);

		int count = 0;
		char c;
		while (myfile.get(c))
		{
			if (count == 0)
				count = 1;
			fwrite(&c, sizeof(c), 1, outFile);
			// count++;
		}
		if (count == 0)
			return 1;

	}

	/*Take our BMP and convert to binary for loading into ISO*/
	int WriteImgToBinary(const char* filename)
	{
		std::string byte;
		std::ifstream myfile;
		myfile.open(filename);
		//open output
		FILE* out;
		fopen_s(&out, "img.bin", "wb");
		if (out == NULL)
		{
			return 1;
		}
		int count = 0;
		char c;
		while (myfile.get(c))
		{
			if (count == 0)
				count = 1;
			fwrite(&c, sizeof(c), 1, out);
			// count++;
		}
		if (count == 0)
			return 1;
		fclose(out);
		//myfile.close();

	}

	/*Take our BMP binary string and write to file for loading into ISO*/
	int WriteBytesToFile(std::vector<BYTE> bytearray, std::string output)
	{

		std::ofstream output_file(output, std::ios::out | std::ios::binary);

		for (int i = 0; i < bytearray.size(); i++)
		{
			output_file.write((const char*)&bytearray[0], bytearray.size());
		}
		output_file.close();
		return 0;
	}

	std::vector<BYTE> readFile(const char* filename)
	{
		// open the file:
		std::streampos fileSize;
		std::ifstream file(filename, std::ios::binary);

		// get its size:
		file.seekg(0, std::ios::end);
		fileSize = file.tellg();
		file.seekg(0, std::ios::beg);

		// read the data:
		std::vector<BYTE> fileData(fileSize);
		file.read((char*)&fileData[0], fileSize);
		file.close();
		return fileData;
	}

};
//Endian Functions//
	// 
	//
	//RedSea integer endianness palindromes
uint16_t EndianU16(uint16_t d)
{
	uint16_t res = _byteswap_ushort(d);
	return res;
}
uint32_t EndianU32(uint32_t d)
{
	uint32_t res = _byteswap_ulong(d);
	return res;
}
//Fill the palindrome functions
void FillU16Palindrome(CPalindromeU16* dst, uint16_t w)
{
	dst->big = EndianU16(w);
	dst->little = w;
}
void FillU32Palindrome(CPalindromeU32* dst, uint32_t d)
{
	dst->big = EndianU32(d);
	dst->little = d;
}
uint64_t EndianU364(uint64_t d)
{
	uint64_t res = _byteswap_uint64(d);
	return res;
}



//write the primary descriptor and TDrv to file
static int writePrimaryDescriptor(const char* outfileName)
{
	//Allocate memory for the object we are serializing the data into
	uint8_t* zero_buf0 = (uint8_t*)calloc(1, myDVD_BLK_SIZE);//system area & reserved fields
	CISOPriDesc* iso_pri = (CISOPriDesc*)calloc(1, DVD_BLK_SIZE),//param: 1 element of size 'harddrive'
		* iso_boot = (CISOPriDesc*)calloc(1, DVD_BLK_SIZE),//This is also known as contiguous allocation. allocates the memory along with initializing the bits to zero.
		* iso_sup = (CISOPriDesc*)calloc(1, DVD_BLK_SIZE),
		* iso_term = (CISOPriDesc*)calloc(1, DVD_BLK_SIZE);

	uint64_t iso_size = 0;
	CElTorito* et = (CElTorito*)calloc(1, DVD_BLK_SIZE);


	/*
	myBITMAPFILEHEADER* file_header = (myBITMAPFILEHEADER*)calloc(1, SECTORSIZE);
	file_header->bfType = kitty.file_header.bfType;
	file_header->bfSize = kitty.file_header.bfSize;
	file_header->bfReserved1 = kitty.file_header.bfReserved1;
	file_header->bfReserved2 = kitty.file_header.bfReserved2;
	file_header->bfOffBits = kitty.file_header.bfOffBits;*/

	//Get the size of the data we will be writing
	//get output size
	FILE* file = NULL; // name: *string* isoFile 
	FILE* outfile = NULL; // name: *string* isoFile 
	fopen_s(&file, "TDRV.bin", "r");
	if (file == NULL)
		return 1;
	fseek(file, 0L, SEEK_END); //0L start //2560
	long int ans = ftell(file) / DVD_BLK_SIZE;
	iso_size = ans; //ans;
	fclose(file);

	//type
	iso_pri->type = ISOT_PRI_VOL_DESC;

	//id
	std::string str = "CD001";
	for (int i = 0; i < str.length(); i++)
	{
		iso_pri->id[i] = str[i];
	}
	//std::memcpy(iso_pri->id, c.toBinary(str), sizeof str);

	//version
	iso_pri->version = 1;

	//Boot System Identifier, must be EL TORITO SPECIFICATION padded
	FillU16Palindrome(&iso_pri->vol_set_size, 1);
	FillU16Palindrome(&iso_pri->vol_seq_num, 1);
	FillU16Palindrome(&iso_pri->log_block_size, DVD_BLK_SIZE);
	FillU32Palindrome(&iso_pri->vol_space_size, iso_size);//iso_size set to 88
	FillU32Palindrome(&iso_pri->root_dir_record.loc, 90);//start root cluster set to 90
	//version
	iso_pri->file_structure_version = FSt_REDSEA;
	//publisher
	str = "TempleOS RedSea";
	for (int i = 0; i < str.length(); i++)
	{
		iso_pri->publisher_id[i] = str[i];// bitset<8>(byte[i]);
	}
	//std::memcpy(iso_pri->publisher_id, c.toBinary(str), sizeof str);
	std::memcpy(iso_sup, iso_pri, DVD_BLK_SIZE);
	iso_sup->type = ISOT_SUPPLEMENTARY_DESC;
	iso_boot->type = ISOT_BOOT_RECORD;
	//id
	str = "CD001";
	for (int i = 0; i < str.length(); i++)
	{
		iso_boot->id[i] = str[i];// bitset<8>(byte[i]);
	}
	//std::memcpy(iso_boot->id, &str, sizeof str);
	iso_boot->version = 1;
	str = "EL TORITO SPECIFICATION";
	//std::memcpy(iso_boot->id, c.toBinary(str), sizeof str);
	int offset = 0;
	for (int i = 0; i < str.length(); i++)
	{
		iso_boot->pad1[i] = str[i];// bitset<8>(byte[i]);
	}
	for (int i = str.length(); i < str.length() + 42; i++)
	{
		iso_boot->pad1[i] = 0x00;// bitset<8>(byte[i]);
		offset = i;
	}
	iso_boot->pad1[offset] = 20;//cant verify

	//FillU32Palindrome(&iso_boot->vol_space_size, 14);

	fopen_s(&outfile, outfileName, "wb");
	if (outfile == NULL)
	{
		printf("Can't write to file, are you sure you don't have it open? %s\n", strerror(errno));
		return 1;

	}

	for (int i = 0; i < myDVD_BLK_SIZE; i++)
		fwrite(zero_buf0, sizeof(zero_buf0), 1, outfile);
	fwrite(iso_pri, sizeof(CISOPriDesc), 1, outfile);//Fileend -4
	iso_term->type = 0xFF;//oxFF but doesnt write correctly
	str = "CD001";
	for (int i = 0; i < str.length(); i++)
	{
		iso_term->id[i] = str[i];// bitset<8>(byte[i]);
	}
	//std::memcpy(iso_boot->id, c.toBinary(str), sizeof str);
	iso_term->version = 1;

	//El Torito Drive Validation Entry
	et->w[0] = 1;
	et->w[1] = 0;
	et->w[2] = 0;
	et->w[3] = 0;
	str = "TempleOS";
	int j = 4;
	for (int i = 0; i < str.length(); i++)
	{
		et->w[j] = str[i];
		j++;
	}
	//std::memcpy(&et->w[2], c.toBinary(str), sizeof str);
	et->w2[15] = 0xAA;
	et->w2[14] = 0x55;//terminator
	et->w2[13] = 0xC7;
	et->w2[12] = 0x2E;
	//j = 0;//to un hardcode the checksum
	//for (int i = 0; i < 16; i++)
	//{
	//	j += et->w[i];//checksum
	//}
	//et->w2[13] = -j;
	et->bootable = 0x88;
	et->media_type = 0;
	et->sect_cnt = 4;
	et->load_rba = 21;//sector 21, eltorito is sector 20



	/*
	//Part 3: time to write to the ISO
	*/
	//uint32_t* d;
	//d = iso_boot(uint8_t*) + 0x47;
	fwrite(iso_boot, sizeof(CISOPriDesc) , 1, outfile);//FBlkWrite????17<<2
	fwrite(iso_sup, sizeof(CISOPriDesc) , 1, outfile);//FBlkWrite????18<<2
	fwrite(iso_term, sizeof(CISOPriDesc) , 1, outfile);
	//fwrite(&iso_term->type, sizeof(CISOPriDesc), 1, outfile);
	//fwrite(iso_term, sizeof(CISOPriDesc), 1, outfile);
	//fwrite(&iso_term->id, sizeof(uint8_t), 1, outfile);

	//fwrite(zero_buf0, sizeof(CISOPriDesc)-sizeof(uint64_t), 1, outfile);
	fwrite(et, sizeof(CISOPriDesc) , 1, outfile);//FBlkWrite???? 20<<2
	fclose(outfile);

	std::ofstream outFinalFile(outfileName, std::ios_base::app | std::ios_base::binary | std::ios_base::out);

	std::ifstream inFile("TDRV.bin", std::ios_base::binary | std::ios_base::in);
	inFile >> std::noskipws;
	char c;
	while (inFile >> c) {
		outFinalFile << c;
	}


	free(et);
	free(iso_pri);
	free(iso_boot);
	free(iso_sup);
	free(iso_term);
	free(zero_buf0);
	return 0;
}

//Program starts here
int ISOBOOTER(int argc, char** argv)
{
	//Part 1 Local Variables
	std::string kernelImage, prefix, isoFile, directory;
	const char* outfileName;
	Convertor c;

	//Part 2 Input from user
	if (argc == 0)
	{
		std::cout << "Redsea Converter\n";

		std::cout << "Enter the Kernel Image Directory Path (all files in directory must be bmp) :";
		std::cin >> kernelImage;
		std::cout << "Enter the Img Prefix Text (Ex: if your files are cat.0.bmp, cat.1.bmp etc, enter 'cat'):";
		std::cin >> prefix;
		std::cout << "Enter the CD ISO Image Output File Name (must be .ISO.C):";
		std::cin >> isoFile;
		outfileName = isoFile.data();
	}
	else
	{
		if (argc == 4)
		{
			kernelImage = argv[1];
			prefix = argv[2];
			outfileName = argv[3];

		}
		else
		{
			std::cout << "Incorrect number of arguments";
			return 1;
		}
	}

	//Part 3 Convert Images to binary
	c.convertImageDirectoryToBinaryArray(kernelImage, prefix);

	//Part 4 Make our drive from the binary data
	int* ptrToImg = c.makeTDrv(kernelImage, isoFile);

	//Part 5 Write ISO9660 Primary Descriptor
	writePrimaryDescriptor(outfileName);


}

// Run program: Ctrl + F5 or Debug > Start Without Debugging menu
// Debug program: F5 or Debug > Start Debugging menu

// Tips for Getting Started: 
//   1. Use the Solution Explorer window to add/manage files
//   2. Use the Team Explorer window to connect to source control
//   3. Use the Output window to see build output and other messages
//   4. Use the Error List window to view errors
//   5. Go to Project > Add New Item to create new code files, or Project > Add Existing Item to add existing code files to the project


#pragma pack(pop)




std::wstring ExePath() {
	TCHAR buffer[MAX_PATH] = { 0 };
	GetModuleFileName(NULL, buffer, MAX_PATH);
	std::wstring::size_type pos = std::wstring(buffer).find_last_of(L"\\/");
	std::wstring returnMe = std::wstring(buffer).substr(0, pos);
	returnMe = returnMe + L"\\moses.bmp";
	return returnMe;
}

int wmain()
{

	return 0;
}



int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
	_In_opt_ HINSTANCE hPrevInstance,
	_In_ LPWSTR    lpCmdLine,
	_In_ int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	/// TODO: Place code here.
	//MessageBox(hInstance, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
	//CreateWindow(" Kernel Image Directory Path ", 0, WS_BORDER | WS_CHILD | WS_VISIBLE, 56, 10, 50, 18, g_hWnd, 0, hInst, 0);
	//CreateWindow("Img Prefix ", 0, WS_BORDER | WS_CHILD | WS_VISIBLE, 56, 10, 50, 18, g_hWnd, 0, hInst, 0);
	//CreateWindow(" Kernel Image Directory Path ", 0, WS_BORDER | WS_CHILD | WS_VISIBLE, 56, 10, 50, 18, g_hWnd, 0, hInst, 0);
	//CreateWindow("CD ISO Image Output File Name", 0, WS_CHILD | WS_VISIBLE, 70, 70, 80, 25, g_hWnd, 0, hInst, 0);
	// Initialize global strings
	LoadStringW(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadStringW(hInstance, IDC_MOSESSTAFFV1, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance(hInstance, nCmdShow))
	{
		return FALSE;
	}

	HACCEL hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_MOSESSTAFFV1));

	MSG msg;

	// Main message loop:
	while (GetMessage(&msg, nullptr, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int)msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEXW wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style = CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc = WndProc;
	wcex.cbClsExtra = 0;
	wcex.cbWndExtra = 0;
	wcex.hInstance = hInstance;
	wcex.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MOSESSTAFFV1));
	wcex.hCursor = LoadCursor(nullptr, IDC_ARROW);
	wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wcex.lpszMenuName = MAKEINTRESOURCEW(IDC_MOSESSTAFFV1);
	wcex.lpszClassName = szWindowClass;
	wcex.hIconSm = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassExW(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	hInst = hInstance; // Store instance handle in our global variable

	HWND hWnd = CreateWindowW(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

	if (!hWnd)
	{
		return FALSE;
	}


	ShowWindow(hWnd, nCmdShow);
	//wmain();
	UpdateWindow(hWnd);

	return TRUE;
}

//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE: Processes messages for the main window.
//
//  WM_COMMAND  - process the application menu
//  WM_PAINT    - Paint the main window
//  WM_DESTROY  - post a quit message and return
//
//
char* encode(const wchar_t* wstr, unsigned int codePage)
{
	int sizeNeeded = WideCharToMultiByte(codePage, 0, wstr, -1, NULL, 0, NULL, NULL);
	char* encodedStr = new char[sizeNeeded];
	WideCharToMultiByte(codePage, 0, wstr, -1, encodedStr, sizeNeeded, NULL, NULL);
	return encodedStr;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{


	switch (message)
	{
	case WM_COMMAND:
	{
		int wmId = LOWORD(wParam);
		// Parse the menu selections:


		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		case 1:

			//GetWindowText(GetDlgItem(hWnd, 1002), reinterpret_cast <char*> ((char*)input3.c_str()), 255);
			input1 = GetWindowTextLength(directory);
			input2 = GetWindowTextLength(directory);
			input3 = GetWindowTextLength(directory);
			//char* t = &text1[0];
			//GetWindowText(directory, t, 255);
			//GetWindowText(prefix, &text2[0], 255);
			//GetWindowText(output, &text3[0], 255);
			//input1 = tstring(text1);
			//input2 = tstring(text2);
			//input3 = tstring(text3);
			GetWindowText(GetDlgItem(hWnd, 1000), text1, 255);
			GetWindowText(GetDlgItem(hWnd, 1001), text2, 255);
			GetWindowText(GetDlgItem(hWnd, 1002), text3, 255);
			//MessageBoxW(0, text1, text1, 0);
			//USES_CONVERSION;
			//GetWindowText(GetDlgItem(hWnd, 1001), reinterpret_cast <char*> ((char*)input2.c_str()), 255);
			//arg1c = T2A(input1);
			//::MessageBox(hWnd, text1, text1, MB_OK);

			for (int i = 0; i < input1; i++)
			{
				arg1c[i] = text1[i];
			}
			for (int i = 0; i < input2; i++)
			{
				arg2c[i] = text2[i];
			}
			for (int i = 0; i < input3; i++)
			{
				arg3c[i] = text3[i];
			}
			
			char* argv[4]; char arg0c[1]; arg0c[0] = '4';
			argv[0] = &arg0c[0];
			argv[1] = arg1c;//encode((wchar_t*)input1.c_str(), CP_UTF8);//arg1c;
			argv[2] = arg2c;//encode((wchar_t*)input2.c_str(), CP_UTF8);//arg2c;
			argv[3] = arg3c;//encode((wchar_t*)input3.c_str(), CP_UTF8);// arg3c;

			ISOBOOTER(4, argv);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
	}
	break;
	case WM_CREATE:
	{
		hwndButton = CreateWindow(
			L"BUTTON",  // Predefined class; Unicode assumed 
			L"CONVERT",      // Button text 
			WS_TABSTOP | WS_VISIBLE | WS_CHILD | BS_DEFPUSHBUTTON,  // Styles 
			10,         // x position 
			10,         // y position 
			100,        // Button width
			100,        // Button height
			hWnd,     // Parent window
			(HMENU)1,       // No menu.
			NULL,
			NULL);      // Pointer not needed.
		directory = CreateWindow(
			L"EDIT",  // Predefined class; Unicode assumed 
			L"DIRECTORY",      // Button text 
			WS_TABSTOP | WS_VISIBLE | WS_CHILD | BS_DEFPUSHBUTTON,  // Styles 
			300,         // x position 
			10,         // y position 
			300,        // Button width
			20,        // Button height
			hWnd,     // Parent window
			(HMENU) 1000,       //1000
			NULL,
			NULL);      // Pointer not needed.
		prefix = CreateWindow(
			L"EDIT",  // Predefined class; Unicode assumed 
			L"PREFIX",      // Button text 
			WS_TABSTOP | WS_VISIBLE | WS_CHILD | BS_DEFPUSHBUTTON,  // Styles 
			300,         // x position 
			40,         // y position 
			300,        // Button width
			20,        // Button height
			hWnd,     // Parent window
			(HMENU)1001,       // 1001
			NULL,
			NULL);      // Pointer not needed.
		output = CreateWindow(
			L"EDIT",  // Predefined class; Unicode assumed 
			L"OUTPUT.ISO.C",      // Button text 
			WS_TABSTOP | WS_VISIBLE | WS_CHILD | BS_DEFPUSHBUTTON,  // Styles 
			300,         // x position 
			70,         // y position 
			300,        // Button width
			20,        // Button height
			hWnd,     // Parent window
			(HMENU)1002,       // 1002
			NULL,
			NULL);      // Pointer not needed.
		hBitmap = (HBITMAP)LoadImage(hInst, ExePath().c_str(), IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
		PlaySound(TEXT("speed.wav"), 0, SND_FILENAME | SND_ASYNC);
		//CreateWindow("EDIT", "", WS_BORDER | WS_CHILD | WS_VISIBLE, 10, 10, 400, 20, hWnd,NULL,NULL,NULL);
		//CreateWindow("Img Prefix ", 0, WS_BORDER | WS_CHILD | WS_VISIBLE, 56, 10, 50, 18, hWnd, NULL, NULL, NULL);
		//CreateWindow(" Kernel Image Directory Path ", 0, WS_BORDER | WS_CHILD | WS_VISIBLE, 56, 10, 50, 18, hWnd, NULL, NULL, NULL);
		//CreateWindow("CD ISO Image Output File Name", 0, WS_CHILD | WS_VISIBLE, 70, 70, 80, 25, hWnd, NULL, NULL, NULL);

		if (hWnd != NULL) { MoveWindow(hWnd, 300, 300, 640, 380, TRUE); }
		break;
	}
	case WM_PAINT:
	{
		PAINTSTRUCT     ps;
		HDC             hdc;
		BITMAP          bitmap;
		HDC             hdcMem;
		HGDIOBJ         oldBitmap;

		hdc = BeginPaint(hWnd, &ps);

		hdcMem = CreateCompatibleDC(hdc);
		oldBitmap = SelectObject(hdcMem, hBitmap);

		GetObject(hBitmap, sizeof(bitmap), &bitmap);
		BitBlt(hdc, 0, 0, bitmap.bmWidth, bitmap.bmHeight, hdcMem, 0, 0, SRCCOPY);

		SelectObject(hdcMem, oldBitmap);
		DeleteDC(hdcMem);

		EndPaint(hWnd, &ps);
	}
	break;
	case WM_DESTROY:
		DeleteObject(hBitmap);
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
